/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.logic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverTileEntity;
import mcjty.rftoolsbuilder.modules.mover.items.VehicleCard;
import mcjty.rftoolsbuilder.modules.mover.network.PacketGrabbedEntitiesToClient;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class EntityMovementLogic {
    private final MoverTileEntity mover;
    private BlockPos destination = null;
    private long starttick;
    private float totalDist;
    private BlockPos source = null;
    private Map<Integer, Vec3> grabbedEntities = new HashMap<Integer, Vec3>();
    private int grabTimeout = 0;
    private int waitABit = 0;

    public EntityMovementLogic(MoverTileEntity mover) {
        this.mover = mover;
    }

    public void setGrabbedEntitiesClient(Set<Integer> grabbedEntities) {
        Level level = this.mover.m_58904_();
        this.grabbedEntities = new HashMap<Integer, Vec3>();
        for (Integer id : grabbedEntities) {
            Entity entity = level.m_6815_(id.intValue());
            if (entity == null) continue;
            this.grabbedEntities.put(id, entity.m_20182_());
        }
    }

    public Vec3 tryMoveVehicleThisPlayer(float partialTicks) {
        Vec3 result = Vec3.f_82478_;
        if (this.destination != null) {
            Player clientPlayer = SafeClientTools.getClientPlayer();
            Level level = this.mover.m_58904_();
            Vec3 startPos = this.getMovingPosition(0.0f, this.starttick);
            Vec3 currentPos = this.getMovingPosition(partialTicks, level.m_46467_());
            double dx = currentPos.f_82479_ - startPos.f_82479_;
            double dy = currentPos.f_82480_ - startPos.f_82480_;
            double dz = currentPos.f_82481_ - startPos.f_82481_;
            if (this.grabbedEntities.containsKey(clientPlayer.m_142049_())) {
                Vec3 basePos = this.grabbedEntities.get(clientPlayer.m_142049_());
                double desiredX = basePos.f_82479_ + dx;
                double desiredY = basePos.f_82480_ + dy;
                double desiredZ = basePos.f_82481_ + dz;
                result = new Vec3(desiredX - clientPlayer.m_20185_(), desiredY - clientPlayer.m_20186_(), desiredZ - clientPlayer.m_20189_());
                clientPlayer.m_6034_(desiredX, desiredY, desiredZ);
                clientPlayer.m_146867_();
                clientPlayer.f_19789_ = 0.0f;
                clientPlayer.m_20256_(Vec3.f_82478_);
                clientPlayer.m_6853_(true);
            }
        }
        return result;
    }

    public void tryMoveVehicleClientEntities(float partialTicks) {
        if (this.destination != null) {
            Player clientPlayer = SafeClientTools.getClientPlayer();
            Level level = this.mover.m_58904_();
            Vec3 startPos = this.getMovingPosition(0.0f, this.starttick);
            Vec3 currentPos = this.getMovingPosition(partialTicks, level.m_46467_());
            double dx = currentPos.f_82479_ - startPos.f_82479_;
            double dy = currentPos.f_82480_ - startPos.f_82480_;
            double dz = currentPos.f_82481_ - startPos.f_82481_;
            for (Map.Entry<Integer, Vec3> pair : this.grabbedEntities.entrySet()) {
                Entity entity = level.m_6815_(pair.getKey().intValue());
                if (entity == null || entity == clientPlayer) continue;
                Vec3 basePos = pair.getValue();
                double desiredX = basePos.f_82479_ + dx;
                double desiredY = basePos.f_82480_ + dy;
                double desiredZ = basePos.f_82481_ + dz;
                entity.m_6034_(desiredX, desiredY, desiredZ);
                entity.m_146867_();
                entity.f_19789_ = 0.0f;
                entity.m_20256_(Vec3.f_82478_);
                entity.m_6853_(true);
            }
        }
    }

    public void setWaitABit(int waitABit) {
        this.waitABit = waitABit;
    }

    public void tryMoveVehicleServer() {
        ItemStack vehicle = this.mover.getCard();
        if (this.destination != null) {
            this.checkUnmounts();
            this.actualMoveServer();
        } else if (!vehicle.m_41619_()) {
            if (this.grabTimeout > 0) {
                --this.grabTimeout;
                this.doGrab(0.0, 0.0, 0.0);
            }
            if (this.waitABit > 0) {
                --this.waitABit;
                return;
            }
            BlockPos destination = VehicleCard.getDesiredDestination(vehicle);
            if (destination != null) {
                if (destination.equals((Object)this.mover.m_58899_())) {
                    VehicleCard.clearDesiredDestination(vehicle);
                    return;
                }
                if (this.mover.hasDirectContectionTo(destination)) {
                    this.setupMovementTo(destination);
                } else {
                    BlockPos dest = this.mover.traverseBreadthFirstWithPath((p, child) -> {
                        if (destination.equals((Object)child.m_58899_())) {
                            return (BlockPos)p.get(0);
                        }
                        return null;
                    });
                    if (dest != null) {
                        this.setupMovementTo(dest);
                    }
                }
            }
        }
    }

    private void checkUnmounts() {
        if (!MoverTileEntity.wantUnmount.isEmpty()) {
            HashSet<Integer> toRemove = new HashSet<Integer>();
            for (Integer id : MoverTileEntity.wantUnmount) {
                if (!this.grabbedEntities.containsKey(id)) continue;
                toRemove.add(id);
                this.grabbedEntities.remove(id);
            }
            if (!toRemove.isEmpty()) {
                MoverTileEntity.wantUnmount.removeAll(toRemove);
                this.syncGrabbedToClient();
            }
        }
    }

    public void setupMovementTo(BlockPos dest) {
        MoverTileEntity destMover;
        Level level = this.mover.m_58904_();
        BlockEntity blockEntity = level.m_7702_(dest);
        if (blockEntity instanceof MoverTileEntity && (destMover = (MoverTileEntity)blockEntity).isAvailable()) {
            BlockPos worldPosition = this.mover.m_58899_();
            destMover.setSource(worldPosition);
            this.destination = dest;
            this.totalDist = (float)Math.sqrt(this.destination.m_203198_((double)worldPosition.m_123341_(), (double)worldPosition.m_123342_(), (double)worldPosition.m_123343_()));
            this.starttick = level.m_46467_();
            this.grabEntities();
            this.mover.markDirtyClient();
        }
    }

    public int getGrabTimeout() {
        return this.grabTimeout;
    }

    public void setGrabTimeout(int grabTimeout) {
        this.grabTimeout = grabTimeout;
    }

    public void clearGrabbedEntities() {
        if (!this.grabbedEntities.isEmpty()) {
            this.grabbedEntities.clear();
            this.mover.m_6596_();
        }
    }

    public void grabEntities() {
        this.grabbedEntities.clear();
        AABB aabb = this.getVehicleAABB();
        Level level = this.mover.m_58904_();
        for (Entity entity : level.m_45976_(Entity.class, aabb)) {
            this.grabbedEntities.put(entity.m_142049_(), entity.m_20182_());
            MoverTileEntity.wantUnmount.remove(entity.m_142049_());
        }
        this.syncGrabbedToClient();
    }

    public void syncGrabbedToClient() {
        Level level = this.mover.m_58904_();
        BlockPos worldPosition = this.mover.m_58899_();
        PacketGrabbedEntitiesToClient packet = new PacketGrabbedEntitiesToClient(worldPosition, this.grabbedEntities.keySet());
        ChunkPos cp = new ChunkPos(worldPosition);
        RFToolsBuilderMessages.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_6325_(cp.f_45578_, cp.f_45579_)), (Object)packet);
    }

    private AABB getVehicleAABB() {
        BlockPos blockPos = this.mover.m_58899_();
        Map<BlockState, List<BlockPos>> blocks = VehicleCard.getBlocks(this.mover.getCard(), blockPos.m_141952_((Vec3i)this.mover.getOffset()));
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        int minz = Integer.MAX_VALUE;
        int maxx = Integer.MIN_VALUE;
        int maxy = Integer.MIN_VALUE;
        int maxz = Integer.MIN_VALUE;
        for (List<BlockPos> value : blocks.values()) {
            for (BlockPos pos : value) {
                minx = Math.min(minx, pos.m_123341_());
                miny = Math.min(miny, pos.m_123342_());
                minz = Math.min(minz, pos.m_123343_());
                maxx = Math.max(maxx, pos.m_123341_() + 1);
                maxy = Math.max(maxy, pos.m_123342_() + 1);
                maxz = Math.max(maxz, pos.m_123343_() + 1);
            }
        }
        return new AABB((double)minx, (double)miny, (double)minz, (double)maxx, (double)maxy, (double)maxz);
    }

    public void doGrab(double dx, double dy, double dz) {
        Level level = this.mover.m_58904_();
        this.grabbedEntities.forEach((id, basePos) -> {
            Entity entity = level.m_6815_(id.intValue());
            if (entity != null && entity.m_6084_()) {
                entity.m_6034_(basePos.f_82479_ + dx, basePos.f_82480_ + dy, basePos.f_82481_ + dz);
                entity.m_146867_();
                entity.f_19789_ = 0.0f;
                entity.m_20256_(Vec3.f_82478_);
                entity.m_6853_(true);
            }
        });
    }

    public void endMoveServer() {
        Vec3 startPos = this.getMovingPosition(0.0f, this.starttick);
        Vec3 currentPos = this.getMovingPosition(0.0f, this.starttick + this.getTotalTicks());
        double dx = currentPos.f_82479_ - startPos.f_82479_;
        double dy = currentPos.f_82480_ - startPos.f_82480_;
        double dz = currentPos.f_82481_ - startPos.f_82481_;
        this.doGrab(dx, dy, dz);
    }

    private void actualMoveServer() {
        Level level = this.mover.m_58904_();
        long totalTicks = this.getTotalTicks();
        long currentTick = level.m_46467_() - this.starttick;
        Vec3 startPos = this.getMovingPosition(0.0f, this.starttick);
        Vec3 currentPos = this.getMovingPosition(0.0f, level.m_46467_() + 1L);
        double dx = currentPos.f_82479_ - startPos.f_82479_;
        double dy = currentPos.f_82480_ - startPos.f_82480_;
        double dz = currentPos.f_82481_ - startPos.f_82481_;
        this.doGrab(dx, dy, dz);
        if (currentTick >= totalTicks) {
            this.mover.arriveAtDestination();
        }
    }

    public long getStarttick() {
        return this.starttick;
    }

    public long getTotalTicks() {
        return (long)this.totalDist;
    }

    public BlockPos getDestination() {
        return this.destination;
    }

    public void setDestination(BlockPos destination) {
        this.destination = destination;
    }

    public BlockPos getSource() {
        return this.source;
    }

    public void setSource(BlockPos source) {
        this.source = source;
    }

    @NotNull
    public Vec3 getMovingPosition(float partialTicks, long gameTick) {
        BlockPos blockPos = this.mover.m_58899_();
        BlockPos destination = this.getDestination();
        Vec3 current = new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        if (destination != null) {
            long totalTicks = this.getTotalTicks();
            long currentTick = gameTick - this.starttick;
            Vec3 dest = new Vec3((double)destination.m_123341_(), (double)destination.m_123342_(), (double)destination.m_123343_());
            current = current.m_165921_(dest, (double)((float)currentTick + partialTicks) / (double)totalTicks);
        }
        return current;
    }

    public void load(CompoundTag tagCompound) {
        this.source = tagCompound.m_128441_("source") ? NbtUtils.m_129239_((CompoundTag)tagCompound.m_128469_("source")) : null;
        this.destination = tagCompound.m_128441_("destination") ? NbtUtils.m_129239_((CompoundTag)tagCompound.m_128469_("destination")) : null;
        this.starttick = tagCompound.m_128454_("starttick");
        this.totalDist = tagCompound.m_128457_("totalDist");
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        this.destination = tagCompound.m_128441_("destination") ? NbtUtils.m_129239_((CompoundTag)tagCompound.m_128469_("destination")) : null;
        this.starttick = tagCompound.m_128454_("starttick");
        this.totalDist = tagCompound.m_128457_("totalDist");
    }

    public void save(@Nonnull CompoundTag tagCompound) {
        if (this.source != null) {
            tagCompound.m_128365_("source", (Tag)NbtUtils.m_129224_((BlockPos)this.source));
        }
        if (this.destination != null) {
            tagCompound.m_128365_("destination", (Tag)NbtUtils.m_129224_((BlockPos)this.destination));
        }
        tagCompound.m_128356_("starttick", this.starttick);
        tagCompound.m_128350_("totalDist", this.totalDist);
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        tagCompound.m_128356_("starttick", this.starttick);
        tagCompound.m_128350_("totalDist", this.totalDist);
        if (this.destination != null) {
            tagCompound.m_128365_("destination", (Tag)NbtUtils.m_129224_((BlockPos)this.destination));
        }
    }
}

